
RTE.default {
	
	# angepasste CSS Datei in fileadmin speichern
	# TIPP: diese Datei ist extrem wichtig für viele Einstellungen. Sie muss alle Klassen
	# enthalten, die der RTE verarbeiten soll, auch und vor allem selbst definierte. 
	# Man kann hier die Frontend-CSS-Datei einbinden, aber ich empfehle eine eigene 
	# Datei für den RTE, da man nicht immer sinnvoll im RTE die exakt gleichen Stile 
	# verwenden kann. Z. B. weisser Text, der im Frontend auf dunklen Hintergründen sitzt. 
	contentCSS = fileadmin/css/rte.css
	
	# Höhe des RTE überschreiben
	# RTEHeightOverride = 750
	
	# Word-Clean aktivieren. ACHTUNG: Definition erforderlich über HTMLparser, siehe unten
	# TIPP: wenn das aktiviert wird, funktionieren die Buttons pastetoggle, pastebehaviour
	# nicht mehr - bzw. man kann nicht mehr unformatiert über die 
	# Zwischenablage einsetzen.
	enableWordClean = 1
	

	
	# Buttons anpassen: 
	# Ich ziehe es vor, alle Buttons komplett abzuschalten und im folgenden nur die zu 
	# aktivieren, die ich auch haben will. Das ändert sich von Projekt zu Projekt; ich 
	# muss also in den folgenden Abschnitten immer Anpassungen vornehmen. 
	hideButtons = *
	showButtons >
	
	# Jetzt wieder die gewünschten Buttons einschalten: 
	
	########################################################################
	# Inline-HTML-Styles: 
	# 
	# TIPP: Inline-Styles müssen zuerst im Extension Setup aktiviert werden!
	# 
	# Alle verfügbaren HTML-Inline-Styles: 
	# formattext, bold, strong, italic, emphasis, big, small, insertedtext, 
	# deletedtext, citation, code, definition, keyboard, monospaced, quotation, 
	# sample, variable, bidioverride, strikethrough, subscript, superscript, underline, span
	
	# Anzeigen
	showButtons := addToList(strong, emphasis, deletedtext, citation, code, quotation, subscript, superscript)
	
	# DropDown-Menü einschalten für weitere HTML-Stile, die nicht als Buttons gezeigt werden: 
	# Dieses Menü kann mehr Inline-Styles enthalten, ohne dass die Werkzeugleiste zugekleistert wird. 
	# es können die gleichen Stile gezeigt werden wie bei den Buttons, aber auch mehr oder weniger, 
	# ganz nach Belieben. 
	showButtons := addToList(formattext)
	
	# Aus dem DropDown-Menü ausschließen (wirkt nur, wenn aktiviert!)
	buttons.formattext.removeItems := addToList(bold, italic, big, small, underline, span)
	# im Dropdown bleiben somit zusätzlich: insertedtext, keyboard, monospaced, sample, variable, bidioverride, definition
	
	# Dropdown mit den HTML-Tag-Namen anzeigen (wirkt nur, wenn aktiviert!): 
	# TIPP: Macht Sinn, wenn die Redakteure HTML können. 
	buttons.formattext.prefixLabelWithTag = 1
	
	
	########################################################################
	# Block- und Text-Style-DropDowns: 
	# 
	# TIPP: die sind eigentlich immer zu aktivieren. 
	showButtons := addToList(blockstylelabel, blockstyle, textstylelabel, textstyle)
	
	# Klassenbezeichnung im Namen anzeigen (default aus)
	# TIPP: nimmt viel Platz weg: wenn, dann sehr kurze Klassennamen!
	# buttons.textstyle.prefixLabelWithClassName = 0;
	# buttons.blockstyle.prefixLabelWithClassName = 0;
	
	########################################################################
	# Formatblock definieren (= Headlines und weitere Blockstile)
	# 
	# alle verfügbaren Optionen: 
	# p, h1, h2, h3, h4, h5, h6, pre, address, article, aside, blockquote, div, footer, header, nav, section
	
	# TIPP: die folgenden Optionen sollten immer angepasst werden. Sie machen den Redakteuren die 
	# Arbeit leichter. Nur formatierte Optionen sollten aktiviert werden. 
	
	# Formatblock-Dropdown anzeigen: 
	showButtons := addToList(formatblock)
	
	# Anzeige der HTML-Tags im Formatblock-DropDown: 
	buttons.formatblock.prefixLabelWithTag = 1
	
	# Optionen ausschalten - nach Bedarf anpassen: 
	buttons.formatblock.removeItems = h1, h5, h6, address, footer, header, nav, section, blockquote, aside
	
	# Optionen sortieren: 
	buttons.formatblock.orderItems = p, h2, h3, h4, pre, article, div
	
	# Optionen umbenennen: 
	# TIPP: das sehe ich als eine der größten Hilfen für die Redakteure. 
	# Das sollte mit den Labels für die Headline zusammenpassen. 
	buttons.formatblock.items.h2.label = Große Hauptüberschrift
	buttons.formatblock.items.h3.label = Untertitel
	buttons.formatblock.items.h4.label = Zwischenüberschrift
	
	########################################################################
	# Listen: 
	# 
	# Standard: orderedlist, unorderedlist, definitionlist, definitionitem, outdent, indent
	showButtons := addToList(orderedlist, unorderedlist, definitionlist, definitionitem, outdent, indent)
	
	########################################################################
	# Standard-Formatierungen: 
	# 
	# Standard: blockquote, left, center, right
	# TIPP: dafür muss es in der CSS-Datei des RTE Klassen geben!
	showButtons := addToList(blockquote, left, center, right)
	

	########################################################################
	# Sonderzeichen
	#
	# Standard: insertcharacter, insertsofthyphen
	showButtons := addToList(insertcharacter, insertsofthyphen)
	
	########################################################################
	# Wichtige Usbility-Buttons, die m. E. nie fehlen sollten:  
	#
	# aufgeteilt, dass sie einzeln aktiviert werden können: 
	
	# Suchen
	showButtons := addToList(findreplace)
	# TIPP: copy, cut, paste sind nicht in allen Browsern verfügbar. 
	showButtons := addToList(copy, cut, paste, undo, redo )
	# Quelltext putzen: 
	showButtons := addToList(removeformat)
	# Einfügeverhalten umschalten - mit und ohne Formatierung: 
	showButtons := addToList(pastetoggle, pastebehaviour)
	
	# Absatz davor / danach kann in best. Situationen sehr hilfreich sein. 
	showButtons := addToList(insertparagraphbefore, insertparagraphafter)
	
	
	
	########################################################################
	# Links 
	# 
	# Link-Werkzeug anschalten
	showButtons := addToList(link, unlink)
	
	# Features des Linkbrowsers deaktivieren ( page,file,url,mail,spec)
	buttons.link.options.removeItems = 
	# Atribut target deaktivieren (Barrierefreiheit verlangt das)
	buttons.link.targetSelector.disabled = 0
	# Popup-Fenster deaktivieren (Barrierefreiheit verlangt das)
	buttons.link.popupSelector.disabled = 0
	# query-Parameter erlauben: damit können Parameter ans Ende des Links angefügt werden. 
	# TIPP: wenn dieser Parameter benutzt wird, ist der Link kein Typolink mehr! 
	# Das heißt, es gibt keine Konvertierung der Links durch RealUrl oder coolURI!
	buttons.link.queryParametersSelector.enabled = 1
	# rel-Attribut erlauben
	# TIPP: auch hier gilt: wird das genutzt ist der Link kein Typolink mehr. 
	buttons.link.relAttribute.enabled = 1
	
	########################################################################
	# Bilder
	# 
	# TIPP: die Anzeige von Bildern muss in der Extension-Konfiguration aktiviert werden!!
	# Generell aktivieren oder deaktivieren im Extension Setup, nicht hier! 
	# Hier wird nur der Button eingeschaltet. 
	# 
	# generell anschalten: 
	showButtons := addToList(image)
	
	# File-Browser ausschalten - nur verlinkte Bilder sind dann möglich. 
	# buttons.image.TYPO3Browser.disabled = 1
	
	# Einzelne Features abschalten (magic, plain, dragdrop, image): 
	# magic: die Bilder werden auf die unten definierte Maximalgröße reduziert
	# plain: fertige Internetbilder bis zu einer maximalen Größe, wie unten definiert
	# dragdrop: Bilder per Drag&Drop ins Textfeld ziehen. Dabei werden die Bilder
	# nicht(!) verkleinert. Damit können sehr große Bilder eingebunden werden 
	# eine Verkleinerung ist aber nur noch über HTML möglich. 
	buttons.image.options.removeItems = dragdrop
	# maximale Größe bei magic definieren: 
	buttons.image.options.magic.maxWidth = 300
	buttons.image.options.magic.maxHeight = 1000
	# maximale Größe bei plain definieren: 
	buttons.image.options.plain.maxWidth = 640
	buttons.image.options.plain.maxHeight = 680
	
	# Eigenschaften der Bildbearbeitung abschalten 
	# mögliche Eigenschaften(align, alt, border, class, clickenlarge, float, 
	# height, paddingTop, paddingRight, paddingBottom, paddingLeft, title, width)
	# Tipp: diese Eigenschaften sollten besser über Klassen definiert werden. 
	# buttons.image.properties.removeItems := addToList(paddingTop, paddingRight, paddingBottom, paddingLeft, align, float, border)
	# erlaubte Klassen auf Bilder (müssen im RTE-CSS definiert sein!)
	buttons.image.properties.class.allowedClasses = 
	# default-Klasse (muss im CSS definiert sein!)
	buttons.image.properties.class.default = 
	
	
	########################################################################
	# Tabellen - immer zusammen aktivieren!
	#
	showButtons := addToList(table, toggleborders, tableproperties, tablerestyle, rowproperties, rowinsertabove, rowinsertunder, rowdelete, rowsplit,  columnproperties, columninsertbefore, columninsertafter, columndelete, columnsplit, cellproperties, cellinsertbefore, cellinsertafter, celldelete, cellsplit, cellmerge)
	
	# Standardklasse kann hier geändert werden (macht selten Sinn)
	# buttons.table.properties.class.default = contenttable
	
	########################################################################
	# Sprachauszeichnungen
	# TIPP: dafür muss static info tables installiert sein, sonst funktioniert es nicht!
	# Damit können HTML-Tags mit aktuellen Sprachen gekennzeichnet werden. 
	#
	
	# showButtons := addToList(language, showlanguagemarks)
	
	# Die nachfolgenden Einstellungen wirken nur, wenn die Buttons oben aktiviert sind. 
	# Default-Sprache der Inhalte einstellen
	defaultContentLanguage = de
	# lang-Attribut oder XML-Atribut einstellen
	buttons.language.useLangAttribute = 1
	buttons.language.useXmlLangAttribute = 0
	# Ausgabe des Sprachcodes vor den Bezeichnungen
	buttons.language.prefixLabelWithCode = 1
	# Anzeige des Sprachdropdowns einstellen, damit nicht alle Sprachen gezeigt werden. 
	buttons.language.restrictToItems = en, de, fr, it, es
	
	
	########################################################################
	# Schreibrichtung für aussereuropäische Sprachen: 
	# 
	# showButtons := addToList(lefttoright, righttoleft)
	
	
	########################################################################
	# Acronyme
	#
	# TIPP: dieses Feature muss konfiguriert werden, sonst passiert gar nichts
	# - es muss static_info_tables installiert sein 
	# (dabei gibt es einen Bug: https://review.typo3.org/#/c/22664/)
	# - weiter muss vorher ein acronym und eine Abkürzung angelegt werden. 
	# - es muss die Page-UID angegeben werden, auf der die Acronyme gespeichert werden. 
	showButtons := addToList(acronym,abbr)
	# Seiten angeben, auf denen die Definitionen gespeichert sind: 
	buttons.acronym.pages = 87
	# Anzahl der Rekursionen - wieviele Unterebenen der obigen Seite
	## buttons.acronym.recursive = 0
	buttons.lockBEUserToDBmounts = 1 
	# TIPP: mir ist es unter 6.1 nicht gelungen, die Acronyme zum Laufen zu bringen. 
	

	########################################################################
	# PROFI-Features: Tag editieren, Microdata anzeigen. 
	# 
	# die drei hier immer zusammen: editelement, showmicrodata, showlanguagemarks
	# => editelement kann alles bearbeiten, somit macht es Sinn, es auch anzuzeigen. 
	# 
	# interessantes Features für Nicht-Profis:
	# => einfache HTML-Korrekturen im Quelltext sind damit möglich
	# 
	 
	# HTML-Modus erlauben: 
	showButtons := addToList(chMode)
	
	# Einfügen von Tags erlauben: 
	# showButtons := addToList(inserttag)
	
	# Sehr weitgehende Bearbeitung von Tags: 
	# showButtons := addToList(editelement, showmicrodata, showlanguagemarks)
	
	# TIPP: wenn man microdate eingeben lassen will, muss das hier aktiviert werden. 
	# Man kann dann style und events wieder deaktivieren. 
	
	# Editelements einschränken: (style, language, microdata, events)
	# buttons.editelement.removeFieldsets = events
	
	# Optionen einschränken: 
	# (id, title, language, direction, onkeydown, onkeypress, onkeyup, onclick, 
	# ondblclick, onmousedown, onmousemove, onmouseout, onmouseover, onmouseup)
	# buttons.editelement.properties.removed = id
	
	
	########################################################################
	# Smileys: 
	# showButtons := addToList(emoticon)
	
	########################################################################
	# Buttons für Attribute, die mit style= umgesetzt werden:
	# 
	# TIPP: Funktioniert nur, wenn das im Extension-Setup auch eingeschaltet wird!
	# TIPP: Empfehle ich ausdrücklich nicht, da die Redakteure damit Müll produzieren.
	# => sie ermöglichen ungewollte Formatierungen, die nicht dem CI entsprechen
	 
	# showButtons := addToList(fontstyle, fontsize, justifyfull, textcolor, bgcolor, textindicator)
	
	########################################################################
	# Rechtschreibprüfung: 
	# TIPP: Muss im Extension-Setup aktiviert werden. Ausserdem muss Aspel im System installiert sein. 
	# showButtons := addToList(spellcheck)
	
	
	########################################################################
	# Benutzerdefinierte Tags, Textbausteine und so weiter: 
	#
	# TIPP: dieses Feature muss konfiguriert und mit Extensions oder Typoscript
	# erweitert werden. Siehe unten. 
	# 
	showButtons := addToList(user)
	
	########################################################################
	# Eigene Klassen definieren - allgemeine Einstellungen im RTE: 
	#
	# TIPP: Alle Klassen müssen in der CSS-Datei des RTE definiert werden!
	
	buttons {
		blockstyle{
			tags{
				# Voreinstellung deaktivieren, damit werden _alle_ Klassen möglich. 
				# Wenn hier etwas zugewiesen wird, müssen alle eigenen Klassen eigens
				# definiert werden! Einfacher ist es, keine Zuweisung zu machen, und
				# die Klassen über das rte.css zuzuweisen. 
				# 
				# Man kann hier aber jedem Tag eigens Klassen erlauben und damit automatisch
				# die nicht aufgeführten Klassen verbieten. 
				div.allowedClasses >
				table.allowedClasses >
				td.allowedClasses >
			}
		}
		textstyle {
			tags {
				# wie oben - deaktivieren, damit alle Klassen in rte.css autmatisch 
				# übernommen werden! Also zum Beispiel: 
				# span.allowedClasses = important, name-of-person, detail
				span.allowedClasses >
			}
		}
		# Einfügen von unformatierten Text beim Öffnen des RTE aktiv. 
		# Achtung: Das Einfügen von unformatiertem Text ist nur möglich, wenn enableWordClean = 0 
		# gesetzt wurde, siehe ganz oben. 
		pastetoggle.setActiveOnRteOpen = 1
		#pastetoggle.hidden = 1
		
	}
	
	# WICHTIG: alle eigenen Klassen müssen eigens erlaubt werden!
	# - Nur Klassen, die hier aufgeführt werden, werden in die Datenbank übernommen. 
	# - alle müssen zusätzlich in der CSS-Datei definiert werden
	# TIPP: das kann auch an anderer Stelle gesammelt passieren. 
	proc.allowedClasses := addToList(redbox,redtext,zitat,quelle,img_in_text_left) 
	
	########################################################################
	# Tabellen
	# 
	# ACHTUNG: SEHR WICHTIG BEI TABELLEN: 
	# Ins TS-Setup muss noch das hier rein - für jede Klasse, die im table-Tag erlaubt werden soll!
	# lib.parseFunc_RTE.externalBlocks.table.stdWrap.HTMLparser.tags.table.fixAttrib.class.list := addToList(alternate)
	# für td ist das nicht nötig. 
	proc.allowedClasses := addToList(alternate,row_odd,row_even,col_odd,row_even)
	
	proc {
		# Basis für die folgenden Einstellungen sind diese Defaults: 
		# allowTags = a,abbr,acronym,b,bdo,blockquote,br,cite,code,col,colgroup,del,dfn,div,em,h1,h2,h3,hr,i,img,li,ol,p,span,strike,strong,sub,sup,table,thead,tbody,tfoot,td,tr,th,ul,pre,dl,dt,dd,q
		# allowTagsOutside := addToList(pre,div)

		# hier werden die erlaubten Attribute der Tags geregelt, 
		# beim Übergang in die Datenbank, also beim Sichern. 
		
		entryHTMLparser_db = 1
		entryHTMLparser_db {
			
			# Übernahme der Defaults in den Parser für den Datenbank-Übergang (default)
			# allowTags < RTE.default.proc.allowTags
			# allowTagsOutside < RTE.default.proc.allowTagsOutside

			# Definition der einzelnen Tags: 
			# TIPP: das muss nicht passieren, man kann dies auch einfach dem RTE überlassen. Dann kann der 
			# ganze Abschnitt tags gelöscht werden. Man kann hier sehr detailliert bestimmen, 
			# welche Parameter jeder Tag haben darf. 
		    tags {
				# Definition, welche Klassen und sonst. Attribute erlaubt sind
				p {
					# erlaubte Attribute
					allowedAttribs = id, title, dir, lang, xml:lang, class, itemscope, itemtype, itemprop
					# align und style-Attribute werden entfernt
					fixAttrib.align.unset = 1
					fixAttrib.style.unset = 1
					# erlaubte Klassen, alle anderen werden entfernt
					fixAttrib.class.list < RTE.default.proc.allowedClasses
					# fixAttrib.class.list = 
					fixAttrib.class.removeIfFalse = 1
				}
				img {
					# erlaubte Attribute
					# allowedAttribs = id, title, dir, lang, xml:lang, class, src, rel, clickenlarge, alt, style
					# clickenlarge => für vergrößerte Darstellung. Achtung: statisches Template im Setup einbinden!
					# align und style-Attribute werden entfernt
					fixAttrib.align.unset = 1
					# Ausnahmsweise style erlauben (für den Wizard): 
					# TIPP: wenn man bei Bildern das Style-Attribut erlauben will (für padding z. B.)
					# dann muss das hier deaktiviert werden!
					fixAttrib.style.unset = 1
					# erlaubte Klassen, alle anderen werden entfernt
				 	fixAttrib.class.list < RTE.default.proc.allowedClasses
					fixAttrib.class.removeIfFalse = 1
				}
				header < .p
				article < .p
				aside < .p
				pre < .p 
				address < .p 
				aside < .p
				blockquote < .p
				footer < .p, 
				nav < .p
				section < .p
				hr < .p
				div < .p
				h1  < .p
				h2  < .p
				h3  < .p
				h4  < .p
				h5  < .p
				h6  < .p
				ul < .p
				ol < .p
				li < .p
				dfn < .p
				dl < .p
				dt < .p
				dd < .p
				blockquote < .p
				table {
					allowedAttribs = id, title, dir, lang, xml:lang, class
					fixAttrib.align.unset = 1
					fixAttrib.style.unset = 1
					fixAttrib.class.list < RTE.default.proc.allowedClasses
					fixAttrib.class.removeIfFalse = 1	
				}
				td {
					allowedAttribs = id, title, dir, lang, xml:lang, class
					fixAttrib.align.unset = 1
					fixAttrib.style.unset = 1
					fixAttrib.class.list < RTE.default.proc.allowedClasses
					fixAttrib.class.removeIfFalse = 1
				}
				th < .td
				hr < .td
			
				span {
					allowedAttribs = id, title, dir, lang, xml:lang, class
					fixAttrib.align.unset = 1
					fixAttrib.style.unset = 1
					fixAttrib.class.list < RTE.default.proc.allowedClasses
					fixAttrib.class.removeIfFalse = 1
				}
				a {
					allowedAttribs = id, title, dir, lang, xml:lang, class, href, name, rel, target
					fixAttrib.align.unset = 1
					fixAttrib.style.unset = 1
					fixAttrib.class.list < RTE.default.proc.allowedClasses
					fixAttrib.class.removeIfFalse = 1
				}
				b.remap = strong
				i.remap = em
				
			}
			# xhtml-cleaning wird ausgeschaltet, da es beim Parsen von 
			# über die Zwischenablage eingefügtem HTML sonst zu schweren Fehlern kommt
			# (zum Beispiel werden fehlerhafte Tags so entfernt, das verweiste </div>-Tags übrig bleiben )
			# Bleibt diese Option aktiviert, so muss beim Einfügen über die Zwischenablage
			# sehr viel restriktiver vorgegangen werden. 
        
			HTMLparser_db.xhtml_cleaning = 0
        
			# aus hygienischen Gründen werden Tags ohne Attribute entfernt
			rmTagIfNoAttrib = span,div,a
		}
	}
}

########################################################################
# Eigene Klassen definieren - Definition der Dropdowns im RTE: 
#
# TIPP: das hier ist nicht unbedingt erforderlich. Wenn es fehlt, werden
# in den DropDowns nur die Klassennamen gezeigt. Aber ich finde es für die 
# Redakteure sehr viel angenehmer, wenn die Klassen benannt sind und sie sogar 
# sehen können wie es aussehen wird. 
#
# TIPP: diese Klassen müssen alle
# - in der CSS-Datei angelegt werden, für alle Tags, auf denen sie wirken sollen
# - in proc.allowedClasses definiert werden, siehe oben. 

RTE.classes {
	# TIPP: aufgrund eines Bugs in früheren Safari-Versionen in den 
	# Klassennamen besser nur Kleinschreibung verwenden. 
	redbox {
		# Sprachdateien aus einer eigenen Extension laden: 
		# so ist einfach eine mehrsprachige Umsetzung für das Backend möglich. 
		# TIPP: diese Extension muss erst angelegt werden!
		# Wenn keine Fremdsprachen nötig sind, dann einfach austauschen gegen Labels. 
		name = LLL:EXT:pl_mods/locallang.xml:rte_redbox 
		# so wird der Stil im Dropdown gezeigt. TIPP: das letzte ; ist wichtig!
		value = color:#fff; padding: 2px; background:#cc0000;
	}
	redtext {
		name = LLL:EXT:pl_mods/locallang.xml:rte_redtext
		value = color:#cc0000;
	}
	zitat {
		name = Zitat
		value = color:#880000;
	}
	quelle {
		name = Quellenangabe
		value = color:#aaa;
	}
	# Tabellenstile
	alternate {
		name = Tabelle mit alternierenden Farben
		value =
		alternating.rows {
			# 0 = even, 1 = odd
			startAt = 1
			oddClass = row_odd
			evenClass = row_even
			oddHeaderClass = row_odd
			evenHeaderClass = row_even
		}
		alternating.columns {
			# 0 = even, 1 = odd
			startAt = 1
			oddClass = col_odd
			evenClass = col_even
			oddHeaderClass = col_odd
			evenHeaderClass = col_even
		}
	}
	row_odd {
		name = Tabellenzeile (ungerade)
	}
	row_even {
		name = Tabellenzeile (gerade)
	}
	col_odd {
		name = Zelle (ungerade Spalte)
	}
	col_even {
		name = Zelle (gerade Spalte)
	}
	img_in_text_left {
		name=Bild links
		value = 
	}
}



######################################################
# HTML-Parser für Einkopieren über die Zwischenablagen
# entfernt Müll bereits beim Einfügen
# TIPP: Dazu muss RTE.default.enableWordClean = 1 aktiviert sein
# TIPP: wenn das aktiviert wird, funktionieren die Buttons pastetoggle, pastebehaviour
# nicht mehr - bzw. man kann nicht mehr unformatiert über die 
# Zwischenablage einsetzen. 

RTE.default.enableWordClean.HTMLparser < RTE.default.proc.entryHTMLparser_db

############################################################
# Links auf Datensätze mit der Extension Linkhandler
# 
# TIPP: die originale Extension funktioniert nicht mehr unter 6.x
# Fork für TYPO3 6.x: https://github.com/fsuter/linkhandlers
# 
# TIPP: hier wird nur das Widget im RTE definiert. Für die Links 
# im Frontend ist noch eine Definition im Typoscript-Setup nötig. 

# Definition des Widgets im RTE: 
RTE.default.tx_linkhandler>
RTE.default.tx_linkhandler {
	# beliebige Bezeichnung
	tx_news { 
		# label / Karteikarte im Widget
		label=News
		# Tabellenname
		listTables=tx_news_domain_model_news
		# Einschränkung des Seitenbaums (optional)
		onlyPids=18
	}
}
# das gleiche nochmals für den normalen Link-Browser in den 
# Contentelementen. 
mod.tx_linkhandler >
mod.tx_linkhandler {
	tx_news { 
		label=News
		listTables=tx_news_domain_model_news
		onlyPids=18
	}	
}

############################################################
# User-Elemente
#
# TIPP: Dazu muss der Button aktiviert werden: showButtons := addToList(user)
# siehe oben. 

RTE.default{
	userElements {
		# beliebige Gruppeneinteilung - das sind nur Labels. 
		10=Wraps
		10 {
			# Erster Wrap: 
			# Label, beliebig
			10 = Zitat mit Quelle
			# Kurzbeschreibung, beliebig
			10.description = ausgewählter Text wird umschlossen als Zitat
			# Modus (wrap, default, processor)
			10.mode = wrap
			# Inhalt des Wraps
			10.content = <q class="zitat">|</q> <span class="quelle">(Quelle: )</span>
			
		}

		20 = Textbausteine
		20 {
			# mode default fügt einfach nur ein. 
			10 = Name
			10.description = Mein Name wird eingefügt. 
			10.mode = default
			10.content = <strong>Peter Linzenkirchner</strong>
			
			20 = Adressblock
			20.description = Mein Adressblock wird eingefügt
			20.mode = default
			20.content (
				<strong>Peter Linzenkirchner</strong> <br>
				Katharinengasse 20 <br>
				Tel: 0821-150565 <br>
				Fax: 0821-150595 <br>
				E-Mail: <a href="mailto:info@lisardo.de">info@lisardo.de</a>
			)
		}
	}
}

